//
//  ScheduleInterfaceController.swift
//  AirAber
//
//  Created by Jan-Peter Krämer on 01/01/16.
//  Copyright © 2016 Mic Pringle. All rights reserved.
//

import WatchKit
import Foundation


class ScheduleInterfaceController: WKInterfaceController {
	@IBOutlet var flightsTable: WKInterfaceTable!
	
	var flights = Flight.allFlights()

    override func awakeWithContext(context: AnyObject?) {
        super.awakeWithContext(context)
		
		flightsTable.setNumberOfRows(flights.count, withRowType: "FlightRow")
		
		for index in 0..<flightsTable.numberOfRows {
			if let controller = flightsTable.rowControllerAtIndex(index) as? FlightRowController {
				controller.flight = flights[index]
			}
		}
		
		// Configure interface objects here.
    }

	override func table(table: WKInterfaceTable, didSelectRowAtIndex rowIndex: Int) {
		let flight = flights[rowIndex]
		presentControllerWithName("Flight", context: flight)
	}
	
    override func willActivate() {
        // This method is called when watch view controller is about to be visible to user
        super.willActivate()
    }

    override func didDeactivate() {
        // This method is called when watch view controller is no longer visible
        super.didDeactivate()
    }

}

class FlightRowController : NSObject {
	@IBOutlet var separator: WKInterfaceSeparator!
	@IBOutlet var originLabel: WKInterfaceLabel!
	@IBOutlet var destinationLabel: WKInterfaceLabel!
	@IBOutlet var flightNumberLabel: WKInterfaceLabel!
	@IBOutlet var statusLabel: WKInterfaceLabel!
	@IBOutlet var planeImage: WKInterfaceImage!
	
	var flight: Flight? {
		didSet {
			if let flight = flight {
				originLabel.setText(flight.origin)
				destinationLabel.setText(flight.destination)
				flightNumberLabel.setText(flight.number)
				if flight.onSchedule {
					statusLabel.setText("On Time")
				} else {
					statusLabel.setText("Delayed")
					statusLabel.setTextColor(UIColor.redColor())
				}
			}
		}
	}
}
